<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:html="http://www.w3.org/1999/xhtml"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwbehaviors="urn:WebWorks-Behaviors-Schema"
                              xmlns:wwvars="urn:WebWorks-Variables-Schema"
                              xmlns:wwnotes="urn:WebWorks-Footnote-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwunits="urn:WebWorks-XSLT-Extension-Units"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwimaging="urn:WebWorks-XSLT-Extension-Imaging"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwmode wwlinks wwfiles wwdoc wwsplits wwtoc wwbehaviors wwvars wwnotes wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwunits wwfilesext wwprojext wwimaging wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterLocaleType" />
 <xsl:param name="ParameterProjectVariablesType" />
 <xsl:param name="ParameterPageTemplateURI" />
 <xsl:param name="ParameterCopyType" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterCategory" />
 <xsl:param name="ParameterUse" />
 <xsl:param name="ParameterDeploy" />


 <xsl:output method="xml" encoding="UTF-8" indent="yes" />
 <xsl:namespace-alias stylesheet-prefix="html" result-prefix="#default" />
 <xsl:strip-space elements="*" />
 <xsl:preserve-space elements="html:script" />


 <xsl:key name="wwfiles-files-by-type" match="wwfiles:File" use="@type" />


 <xsl:include href="wwtransform:common/companyinfo/companyinfo_content.xsl" />
 <xsl:include href="wwtransform:common/files/filter.xsl" />
 <xsl:include href="wwtransform:html/css_properties.xsl" />
 <xsl:include href="wwtransform:common/variables/variables.xsl" />
 <xsl:include href="wwtransform:common/pages/pagetemplate.xsl" />
 <xsl:include href="wwtransform:uri/uri.xsl" />
 <xsl:include href="wwformat:Transforms/connect_utilities.xsl" />
 <xsl:include href="wwformat:Transforms/connect_files.xsl" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath($ParameterPageTemplateURI), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath($ParameterPageTemplateURI)))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/companyinfo/companyinfo_content.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/companyinfo/companyinfo_content.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/files/filter.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/files/filter.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:html/css_properties.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:html/css_properties.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/variables/variables.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/variables/variables.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/pages/pagetemplate.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/pages/pagetemplate.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:uri/uri.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:uri/uri.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwformat:Transforms/connect_utilities.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwformat:Transforms/connect_utilities.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwformat:Transforms/connect_files.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwformat:Transforms/connect_files.xsl')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <!-- Locale -->
 <!--        -->
 <xsl:variable name="GlobalLocalePath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterLocaleType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalLocale" select="wwexsldoc:LoadXMLWithoutResolver($GlobalLocalePath)" />


 <!-- Mapping Entry Sets -->
 <!--                    -->
 <xsl:variable name="GlobalMapEntrySetsPath" select="wwuri:AsFilePath('wwtransform:html/mapentrysets.xml')" />
 <xsl:variable name="GlobalMapEntrySets" select="wwexsldoc:LoadXMLWithoutResolver($GlobalMapEntrySetsPath)" />


 <!-- Page Template -->
 <!--               -->
 <xsl:variable name="GlobalPageTemplatePath" select="wwuri:AsFilePath($ParameterPageTemplateURI)" />
 <xsl:variable name="GlobalPageTemplate" select="wwexsldoc:LoadXMLWithoutResolver($GlobalPageTemplatePath)" />


 <!-- Page template include files -->
 <!--                             -->
 <xsl:variable name="GlobalPageTemplateIncludeFilesAsXML">
  <xsl:apply-templates select="$GlobalPageTemplate" mode="wwmode:pagetemplate-include-files">
   <xsl:with-param name="ParamPageTemplateURI" select="$ParameterPageTemplateURI" />
  </xsl:apply-templates>
 </xsl:variable>
 <xsl:variable name="GlobalPageTemplateIncludeFiles" select="msxsl:node-set($GlobalPageTemplateIncludeFilesAsXML)" />


 <!-- Project variables -->
 <!--                   -->
 <xsl:variable name="GlobalProjectVariablesPath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterProjectVariablesType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalProjectVariables" select="wwexsldoc:LoadXMLWithoutResolver($GlobalProjectVariablesPath)" />


 <!-- Connect Pages -->
 <!--               -->
 <xsl:variable name="GlobalSearchPagePath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), 'connect', 'search.html')" />


 <!-- Project files -->
 <!--               -->
 <xsl:variable name="GlobalProjectFiles" select="wwfilesystem:GetFiles(wwprojext:GetProjectFilesDirectoryPath())" />
 <xsl:variable name="GlobalProjectFilesPaths">
  <xsl:for-each select="$GlobalProjectFiles/wwfiles:Files/wwfiles:File">
   <xsl:value-of select="@path" />
   <xsl:value-of select="':'" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalProjectFilesChecksum" select="wwstring:MD5Checksum($GlobalProjectFilesPaths)" />


 <!-- Project files as splits -->
 <!--                         -->
 <xsl:variable name="GlobalProjectFilesSplitsAsXML">
  <xsl:call-template name="Connect-Project-Files-As-Splits">
   <xsl:with-param name="ParamProjectFiles" select="$GlobalProjectFiles" />
  </xsl:call-template>
 </xsl:variable>
 <xsl:variable name="GlobalProjectFilesSplits" select="msxsl:node-set($GlobalProjectFilesSplitsAsXML)" />


 <xsl:variable name="GlobalFilenameSpacesToUnderscores" select="wwprojext:GetFormatSetting('filename-spaces-to-underscores') = 'true'" />
 <xsl:variable name="GlobalFilenameSpacesToUnderscoresSearchString">
  <xsl:if test="$GlobalFilenameSpacesToUnderscores">
   <xsl:text> </xsl:text>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="GlobalFilenameSpacesToUnderscoresReplaceString">
  <xsl:if test="$GlobalFilenameSpacesToUnderscores">
   <xsl:text>_</xsl:text>
  </xsl:if>
 </xsl:variable>

 <xsl:variable name="GlobalInvalidPathCharactersExpression" select="'[#&amp;?]'" />

 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Get page template files -->
   <!--                         -->
   <xsl:variable name="VarPageTemplateFilesAsXML">
    <xsl:apply-templates select="$GlobalPageTemplate" mode="wwmode:pagetemplate-files" />
   </xsl:variable>
   <xsl:variable name="VarPageTemplateFiles" select="msxsl:node-set($VarPageTemplateFilesAsXML)" />
   <xsl:variable name="VarPageTemplateFilesPaths">
    <xsl:for-each select="$VarPageTemplateFiles/wwpage:File">
     <xsl:value-of select="@path" />
     <xsl:value-of select="':'" />
    </xsl:for-each>
   </xsl:variable>
   <xsl:variable name="VarPageTemplateFilesChecksum" select="wwstring:MD5Checksum($VarPageTemplateFilesPaths)" />

   <!-- Splash Page -->
   <!--             -->
   <xsl:variable name="VarProgressSplashStart" select="wwprogress:Start(1)" />

   <!-- Aborted? -->
   <!--          -->
   <xsl:if test="not(wwprogress:Abort())">
    <xsl:for-each select="$GlobalProject[1]">
     <xsl:variable name="VarFormatConfiguration" select="key('wwproject-formatconfigurations-by-targetid', wwprojext:GetFormatID())[1]" />
     <xsl:variable name="VarMergeSettings" select="$VarFormatConfiguration/wwproject:MergeSettings" />

     <!-- Create splash page -->
     <!--                    -->
     <xsl:variable name="VarPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), 'connect', 'splash.html')" />
     <xsl:call-template name="Splash">
      <xsl:with-param name="ParamPath" select="$VarPath" />
      <xsl:with-param name="ParamVariables" select="$GlobalProjectVariables//wwvars:Variable" />
      <xsl:with-param name="ParamMergeSettings" select="$VarMergeSettings" />
      <xsl:with-param name="ParamPageTemplateFiles" select="$VarPageTemplateFiles" />
      <xsl:with-param name="ParamPageTemplateFilesChecksum" select="$VarPageTemplateFilesChecksum" />
     </xsl:call-template>
    </xsl:for-each>
   </xsl:if>

   <xsl:variable name="VarProgressSplashEnd" select="wwprogress:End()" />

  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="Splash">
  <xsl:param name="ParamPath" />
  <xsl:param name="ParamVariables" />
  <xsl:param name="ParamMergeSettings" />
  <xsl:param name="ParamPageTemplateFiles" />
  <xsl:param name="ParamPageTemplateFilesChecksum" />

  <!-- Determine output directory path -->
  <!--                                 -->
  <xsl:variable name="VarOutputDirectoryPath" select="wwfilesystem:GetDirectoryName($ParamPath)" />

  <!-- Output -->
  <!--        -->
  <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($ParamPath, concat($GlobalProject/wwproject:Project/@ChangeID, ':', $ParamPageTemplateFilesChecksum), '', '', concat($GlobalActionChecksum, ':', $GlobalProjectFilesChecksum))" />
  <xsl:if test="not($VarUpToDate)">
   <!-- Page Rule -->
   <!--           -->
   <xsl:variable name="VarPageRule" select="wwprojext:GetRule('Page', wwprojext:GetFormatSetting('splash-page-style'))" />

   <xsl:variable name="VarResultAsXML">
    <!-- Conditions -->
    <!--            -->
    <xsl:variable name="VarConditionsAsXML">
     <!-- Google Translation -->
     <!--                    -->
     <xsl:if test="wwprojext:GetFormatSetting('google-translate') = 'true'">
      <wwpage:Condition name="google-translation-enabled" />
     </xsl:if>

     <!-- Company Info -->
     <!--              -->
     <xsl:call-template name="CompanyInfo-Conditions">
      <xsl:with-param name="ParamPageRule" select="$VarPageRule" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="VarConditions" select="msxsl:node-set($VarConditionsAsXML)" />

    <!-- Replacements -->
    <!--              -->
    <xsl:variable name="VarReplacementsAsXML">
     <!-- body-class -->
     <!--            -->
     <wwpage:Replacement name="body-class">
      <xsl:attribute name="value">
       <!-- Additional CSS classes -->
       <!--                        -->
       <xsl:variable name="VarAdditionalCSSClassesOption" select="normalize-space($VarPageRule/wwproject:Options/wwproject:Option[@Name = 'additional-css-classes']/@Value)" />
       <xsl:value-of select="$VarAdditionalCSSClassesOption" />
      </xsl:attribute>
     </wwpage:Replacement>

     <!-- body-style -->
     <!--            -->
     <wwpage:Replacement name="body-style">
      <xsl:attribute name="value">
       <!-- CSS properties -->
       <!--                -->
       <xsl:variable name="VarCSSPropertiesAsXML">
        <xsl:call-template name="CSS-TranslateProjectProperties">
         <xsl:with-param name="ParamProperties" select="$VarPageRule/wwproject:Properties/wwproject:Property" />
         <xsl:with-param name="ParamFromAbsoluteURI" select="$ParamPath" />
         <xsl:with-param name="ParamSplits" select="$GlobalProjectFilesSplits" />
        </xsl:call-template>
       </xsl:variable>
       <xsl:variable name="VarCSSProperties" select="msxsl:node-set($VarCSSPropertiesAsXML)/wwproject:Property" />

       <xsl:call-template name="CSS-InlineProperties">
        <xsl:with-param name="ParamProperties" select="$VarCSSProperties[string-length(@Value) &gt; 0]" />
       </xsl:call-template>
      </xsl:attribute>
     </wwpage:Replacement>

     <!-- Locale -->
     <!--        -->
     <wwpage:Replacement name="locale" value="{wwprojext:GetFormatSetting('locale', 'en')}" />

     <!-- Content Type -->
     <!--              -->
     <wwpage:Replacement name="content-type" value="{concat('text/html;charset=', wwprojext:GetFormatSetting('encoding', 'utf-8'))}" />

     <!-- Title -->
     <!--       -->
     <xsl:variable name="VarMergeTitle">
      <xsl:choose>
       <xsl:when test="string-length($ParamMergeSettings/@Title) &gt; 0">
        <xsl:value-of select="$ParamMergeSettings/@Title" />
       </xsl:when>

       <xsl:otherwise>
        <xsl:value-of select="wwprojext:GetFormatName()" />
       </xsl:otherwise>
      </xsl:choose>
     </xsl:variable>
     <wwpage:Replacement name="title" value="{$VarMergeTitle}" />
     <wwpage:Replacement name="navigation-previous-title" value="{$GlobalLocale/wwlocale:Locale/wwlocale:Strings/wwlocale:String[@name = 'Previous']/@value}" />
     <wwpage:Replacement name="navigation-next-title" value="{$GlobalLocale/wwlocale:Locale/wwlocale:Strings/wwlocale:String[@name = 'Next']/@value}" />
     <wwpage:Replacement name="navigation-toc-title" value="{$GlobalLocale/wwlocale:Locale/wwlocale:Strings/wwlocale:String[@name = 'TOCTabLabel']/@value}" />
     <wwpage:Replacement name="navigation-index-title" value="{$GlobalLocale/wwlocale:Locale/wwlocale:Strings/wwlocale:String[@name = 'IXTabLabel']/@value}" />
     <wwpage:Replacement name="navigation-search-title" value="{$GlobalLocale/wwlocale:Locale/wwlocale:Strings/wwlocale:String[@name = 'SearchTabLabel']/@value}" />

     <wwpage:Replacement name="navigation-toc-link" value="#" />
     <wwpage:Replacement name="navigation-index-link" value="#" />
     <wwpage:Replacement name="navigation-search-link">
      <xsl:call-template name="Connect-URI-GetRelativeTo">
       <xsl:with-param name="ParamDestinationURI" select="$GlobalSearchPagePath" />
       <xsl:with-param name="ParamSourceURI" select="$ParamPath" />
      </xsl:call-template>
     </wwpage:Replacement>

     <!-- Company Info -->
     <!--              -->
     <xsl:call-template name="CompanyInfo-Replacements">
      <xsl:with-param name="ParamPageRule" select="$VarPageRule" />
      <xsl:with-param name="ParamPagePath" select="$ParamPath" />
      <xsl:with-param name="ParamSplits" select="$GlobalProjectFilesSplits" />
     </xsl:call-template>

     <!-- Variables -->
     <!--           -->
     <xsl:variable name="VarVariablesAsXML">
      <xsl:call-template name="Variables-Filter-Last-Unique">
       <xsl:with-param name="ParamVariables" select="$ParamVariables" />
      </xsl:call-template>
     </xsl:variable>
     <xsl:variable name="VarVariables" select="msxsl:node-set($VarVariablesAsXML)/wwvars:Variable" />
     <xsl:call-template name="Variables-Page-String-Replacements">
      <xsl:with-param name="ParamVariables" select="$VarVariables" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="VarReplacements" select="msxsl:node-set($VarReplacementsAsXML)" />

    <!-- Map common characters -->
    <!--                       -->
    <wwexsldoc:MappingContext>
     <xsl:copy-of select="$GlobalMapEntrySets/wwexsldoc:MapEntrySets/wwexsldoc:MapEntrySet[@name = 'common']/wwexsldoc:MapEntry" />

     <!-- Invoke page template -->
     <!--                      -->
     <xsl:apply-templates select="$GlobalPageTemplate" mode="wwmode:pagetemplate">
      <xsl:with-param name="ParamPageTemplateURI" select="$ParameterPageTemplateURI" />
      <xsl:with-param name="ParamOutputDirectoryPath" select="$VarOutputDirectoryPath" />
      <xsl:with-param name="ParamOutputPath" select="$ParamPath" />
      <xsl:with-param name="ParamConditions" select="$VarConditions" />
      <xsl:with-param name="ParamReplacements" select="$VarReplacements" />
     </xsl:apply-templates>
    </wwexsldoc:MappingContext>
   </xsl:variable>

   <!-- Aborted? -->
   <!--          -->
   <xsl:if test="not(wwprogress:Abort())">
    <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
    <xsl:variable name="VarPrettyPrint">
     <xsl:choose>
      <xsl:when test="wwprojext:GetFormatSetting('file-processing-pretty-print') = 'true'">
       <xsl:text>yes</xsl:text>
      </xsl:when>

      <xsl:otherwise>
       <xsl:text>no</xsl:text>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:variable>
    <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $ParamPath, 'utf-8', 'html', '5.0', $VarPrettyPrint, 'yes', 'no', 'urn:WebWorks_DOCTYPE_ElementOnly', '')" />
   </xsl:if>
  </xsl:if>

  <!-- Aborted? -->
  <!--          -->
  <xsl:if test="not(wwprogress:Abort())">
   <!-- Record files -->
   <!--              -->
   <wwfiles:File path="{$ParamPath}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($ParamPath)}" projectchecksum="{concat($GlobalProject/wwproject:Project/@ChangeID, ':', $ParamPageTemplateFilesChecksum)}" groupID="" documentID="" actionchecksum="{concat($GlobalActionChecksum, ':', $GlobalProjectFilesChecksum)}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
    <wwfiles:Depends path="{$GlobalLocalePath}" checksum="{wwfilesystem:GetChecksum($GlobalLocalePath)}" groupID="" documentID="" />
    <wwfiles:Depends path="{$GlobalMapEntrySetsPath}" checksum="{wwfilesystem:GetChecksum($GlobalMapEntrySetsPath)}" groupID="" documentID="" />
    <wwfiles:Depends path="{$GlobalPageTemplatePath}" checksum="{wwfilesystem:GetChecksum($GlobalPageTemplatePath)}" groupID="" documentID="" />
    <wwfiles:Depends path="{$GlobalProjectVariablesPath}" checksum="{wwfilesystem:GetChecksum($GlobalProjectVariablesPath)}" groupID="" documentID="" />

    <!-- Page Template Include Files -->
    <!--                             -->
    <xsl:for-each select="$GlobalPageTemplateIncludeFiles">
     <xsl:variable name="VarFile" select="." />

     <wwfiles:Depends path="{$VarFile/@path}" checksum="{wwfilesystem:GetChecksum($VarFile/@path)}" groupID="" documentID="" />
    </xsl:for-each>
   </wwfiles:File>
  </xsl:if>

  <!-- Page Template Files -->
  <!--                     -->
  <xsl:for-each select="$ParamPageTemplateFiles/wwpage:File">
   <xsl:variable name="VarPageTemplateFile" select="." />

   <!-- Get source and destination paths -->
   <!--                                  -->
   <xsl:variable name="VarSourcePath" select="wwuri:AsFilePath(concat('wwformat:Pages/', $VarPageTemplateFile/@path))" />
   <xsl:variable name="VarDestinationPath" select="wwfilesystem:Combine($VarOutputDirectoryPath, $VarPageTemplateFile/@path)" />

   <!-- Copy -->
   <!--      -->
   <xsl:variable name="VarPageTemplateFileUpToDate" select="wwfilesext:UpToDate($VarDestinationPath, '', '', '', concat($GlobalActionChecksum, ':', $VarSourcePath))" />
   <xsl:if test="not($VarPageTemplateFileUpToDate)">
    <xsl:variable name="VarIgnore" select="wwfilesystem:CopyFile($VarSourcePath, $VarDestinationPath)" />
   </xsl:if>

   <!-- Report Files -->
   <!--              -->
   <wwfiles:File path="{$VarDestinationPath}" type="{$ParameterCopyType}" checksum="{wwfilesystem:GetChecksum($VarDestinationPath)}" projectchecksum="" groupID="" documentID="" actionchecksum="{concat($GlobalActionChecksum, ':', $VarSourcePath)}" category="" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
    <wwfiles:Depends path="{$VarSourcePath}" checksum="{wwfilesystem:GetChecksum($VarSourcePath)}" groupID="" documentID="" />
   </wwfiles:File>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
